<?php

namespace Sarav\Multiauth\Foundation;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Sarav\Multiauth\Foundation\RedirectsUsers;

trait RegistersUsers
{
    use RedirectsUsers;

    /**
     * Show the application registration form.
     *
     * @return \Illuminate\Http\Response
     */
    public function getRegister()
    {
        return view($this->user().'.register');
    }

    /**
     * Handle a registration request for the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function postRegister(Request $request)
    {
        $validator = $this->validator($request->all());

        if ($validator->fails()) {
            $this->throwValidationException(
                $request, $validator
            );
        }

        Auth::login($this->user(), $this->create($request->all()));

        return redirect($this->redirectPath());
    }
}
